<x-app-layout>
    @php
        // Mapping 4 sensor per mesin (ubah sesuai data kamu)
        $sensorMeta = [
            ['key' => 'amp',  'label' => 'AMP',  'unit' => 'A',  'decimals' => 2],
            ['key' => 'hm',   'label' => 'HM',   'unit' => '',   'decimals' => 2],
            ['key' => 'temp', 'label' => 'TEMP', 'unit' => '° C', 'decimals' => 1],
            ['key' => 'moist','label' => 'MOIST','unit' => '%',  'decimals' => 1],
        ];
    @endphp

    @push('head')
        @vite(['resources/css/app.css', 'resources/css/dashboard.css'])
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
        <script src="https://cdn.jsdelivr.net/npm/sweetalert2@11"></script>
    @endpush

    <header class="dashboard-header"
        style="display:flex;flex-direction:column;align-items:center;justify-content:center;text-align:center;position:relative;">
        <span class="text-xs uppercase tracking-wide text-white/80 flex items-center gap-2">
            PT. Tuju Kuda Hitam Sakti
            <!-- <i class="fa-solid fa-industry"></i> -->
        </span>
        <h1 style="font-size: 1.25rem; margin-top: 0.5rem;">Monitoring Mesin</h1>
    </header>

    <div class="content-container">

        {{-- GRID 4 x N --}}
        <div id="machineGrid" class="grid grid-cols-2 md:grid-cols-4 xl:grid-cols-6 gap-2">
            @foreach ($machines as $m)
                @php
                    $rawName = $m['name'] ?? 'MESIN';
                    $slug = preg_replace('/[^A-Za-z0-9_-]+/', '-', $rawName);
                    $slug = trim($slug, '-');
                    $cardId = 'card-' . ($slug !== '' ? $slug : ($m['id'] ?? 'unknown'));
                @endphp
                <div id="{{ $cardId }}" class="rounded-xl border bg-white shadow-sm hover:shadow-md transition p-3">
                    <div class="flex items-start justify-between gap-2">
                        <div>
                            <div class="text-[13px] font-extrabold text-slate-900 leading-tight">
                                {{ $m['name'] ?? 'MESIN' }}
                            </div>
                            <div class="mt-0.5 text-[9px] font-mono text-slate-500 last-updated">
                                {{ $m['last_updated'] ?? '-' }}
                            </div>
                        </div>
                    </div>
                    <div class="mt-3 grid grid-cols-2 gap-2 sensor-values">
                        @foreach ($sensorMeta as $s)
                            @php
                                $val = $m[$s['key']] ?? null;
                            @endphp
                            <div class="rounded-xl bg-slate-50 p-3">
                                <div class="text-[10px] font-extrabold text-slate-500 uppercase tracking-wider">
                                    {{ $s['label'] }}
                                </div>
                                <div class="mt-1 text-base font-black text-slate-900">
                                    <span class="sensor-value" data-sensor="{{ $s['key'] }}">
                                        {{ is_numeric($val) ? number_format($val, $s['decimals']) : '-' }}
                                    </span>
                                    @if($s['unit'] !== '')
                                        <span class="text-xs font-bold text-slate-500">{{ $s['unit'] }}</span>
                                    @endif
                                </div>
                            </div>
                        @endforeach
                    </div>
                </div>
            @endforeach
        </div>
        <div>
            <div id="customRangeModal" class="modal-overlay custom-range-modal">
            <div class="modal-content">
                <div class="modal-header">
                <h3><i class="fa-regular fa-calendar-days"></i> Select Custom Date & Time Range</h3>
                <button type="button" id="btnCloseModal" class="modal-close">
                    <i class="fa-solid fa-xmark"></i>
                </button>
                </div>

                <div class="modal-body">
                <div class="date-picker-group">
                    <div class="date-picker-field">
                    <label><i class="fa-solid fa-calendar-check"></i> Start Date & Time</label>
                    <input type="text" id="startDateTime" class="datetime-input" placeholder="Select start date & time">
                    </div>
                    <div class="date-picker-field">
                    <label><i class="fa-solid fa-calendar-xmark"></i> End Date & Time</label>
                    <input type="text" id="endDateTime" class="datetime-input" placeholder="Select end date & time">
                    </div>
                </div>

                <div class="modal-footer">
                    <button type="button" id="btnCancel" class="btn-cancel">
                        <i class="fa-solid fa-ban"></i> Cancel
                    </button>
                    <button type="button" id="btnApply" class="btn-apply">
                        <i class="fa-solid fa-check"></i> Apply Range
                    </button>
                </div>
                </div>
            </div>
            </div>

        </div>

        {{-- REPORT DOWNLOAD MODAL --}}
        <div id="reportDownloadModal" class="modal-overlay custom-range-modal">
            <div class="modal-content">
                <div class="modal-header">
                    <h3><i class="fa-solid fa-file-excel"></i> Buat Laporan Mesin Press</h3>
                    <button type="button" id="btnCloseReportModal" class="modal-close">
                        <i class="fa-solid fa-xmark"></i>
                    </button>
                </div>

                <div class="modal-body">
                    <form id="reportForm" action="{{ route('machines.download-report') }}" method="GET">
                        <div class="date-picker-group">
                            <div class="date-picker-field">
                                <label><i class="fa-solid fa-calendar-check"></i> Start Date & Time</label>
                                <input type="text" id="startDateTimeReport" name="start" class="datetime-input" 
                                    placeholder="Select start date & time" required>
                            </div>
                            <div class="date-picker-field">
                                <label><i class="fa-solid fa-calendar-xmark"></i> End Date & Time</label>
                                <input type="text" id="endDateTimeReport" name="end" class="datetime-input" 
                                    placeholder="Select end date & time" required>
                            </div>
                        </div>

                        <div class="date-picker-group mt-4">
                            <div class="date-picker-field">
                                <label><i class="fa-solid fa-layer-group"></i> Line</label>
                                <input type="text" id="lineInput" name="line" class="datetime-input" 
                                    placeholder="Contoh: I, II, III" required>
                            </div>
                            <div class="date-picker-field">
                                <label><i class="fa-solid fa-calendar"></i> Hari Kerja</label>
                                <input type="number" id="hariKerjaInput" name="hari_kerja" class="datetime-input" 
                                    placeholder="Jumlah hari kerja" min="1" required>
                            </div>
                        </div>

                        <div class="date-picker-group mt-4">
                            <div class="date-picker-field">
                                <label><i class="fa-solid fa-clock"></i> Jam Kerja per Hari</label>
                                <input type="number" id="jamKerjaInput" name="jam_kerja" class="datetime-input" 
                                    placeholder="Jam per hari" min="1" required>
                            </div>
                            <div class="date-picker-field">
                                <label><i class="fa-solid fa-box"></i> Total Briket (Batang)</label>
                                <input type="number" id="totalBriketInput" name="total_briket" class="datetime-input" 
                                    placeholder="Jumlah briket" min="0" required>
                            </div>
                        </div>

                        <div class="modal-footer">
                            <button type="button" id="btnCancelReport" class="btn-cancel">
                                <i class="fa-solid fa-ban"></i> Cancel
                            </button>
                            <button type="submit" class="btn-download" style="background: #10b981;">
                                <i class="fa-solid fa-file-excel"></i> Download Laporan
                            </button>
                        </div>
                    </form>
                </div>
            </div>
        </div>

        {{-- TABLE CARD --}}
        <div class="data-row mt-6">
            <div class="table-card" style="grid-column: 1 / -1;">
                <div class="table-header-controls">
                    <h3>Detail Data Mesin</h3>
                    <div class="table-controls">
                        <select class="filter-select filter-pill" id="summaryFilterSelect">
                            <option value="1h" selected>1 Hours</option>
                            <option value="2h">2 Hours</option>
                            <option value="4h">4 Hour</option>
                            <option value="8h">8 Hour</option>
                            <option value="16h">16 Hour</option>
                            <option value="24h">24 Hour</option>
                            <option value="shift1">Shift 1 Terakhir</option>
                            <option value="shift2">Shift 2 Terakhir</option>
                            <option value="shift3">Shift 3 Terakhir</option>
                        </select>
                        <button class="btn-custom-range btn-custom-range-pill" id="btnModeCustom" onclick="switchTableMode('custom')">
                            <i class="fa-regular fa-calendar-days"></i> Custom Range
                        </button>
                        <button class="btn-custom-range btn-custom-range-pill" id="btnBuatLaporan" onclick="openReportModal()">
                            <i class="fa-solid fa-download"></i> Buat Laporan
                        </button>
                    </div>
                </div>

                <div class="table-shell">
                    <table>
                        <thead>
                            <tr>
                                <th class="cursor-pointer hover:bg-slate-50 transition" onclick="toggleSort('name')">
                                    No. Mesin <i class="fa-solid fa-sort text-slate-300 ml-1" id="sort-icon-name"></i>
                                </th>
                                <th class="text-slate-500">Timestamp</th>
                                @foreach ($sensorMeta as $s)
                                    <th class="cursor-pointer hover:bg-slate-50 transition" onclick="toggleSort('{{ $s['key'] }}')">
                                        {{ $s['label'] }} <i class="fa-solid fa-sort text-slate-300 ml-1" id="sort-icon-{{ $s['key'] }}"></i>
                                    </th>
                                @endforeach
                            </tr>
                        </thead>
                        <tbody id="machinesTableBody">
                            @foreach ($machines as $m)
                                <tr class="border-b border-slate-100">
                                    <td class="px-4 py-3 font-semibold text-slate-700">{{ $m['name'] ?? '-' }}</td>
                                    <td class="px-4 py-3 text-slate-600">{{ $m['last_updated'] ?? '-' }}</td>
                                    @foreach ($sensorMeta as $s)
                                        @php $v = $m[$s['key']] ?? null; @endphp
                                        <td class="px-4 py-3 font-semibold text-slate-900">
                                            {{ is_numeric($v) ? number_format($v, $s['decimals']) : '-' }}
                                            @if($s['unit'] !== '')
                                                <span class="text-xs text-slate-500 font-semibold">{{ $s['unit'] }}</span>
                                            @endif
                                        </td>
                                    @endforeach
                                </tr>
                            @endforeach
                        </tbody>
                    </table>
                </div>

                <div class="table-footer">
                    <div class="table-footer-left">
                        <label>Show:</label>
                        <select id="perPageSelect" class="pagination-select">
                            <option value="10">10</option>
                            <option value="20" selected>20</option>
                            <option value="50">50</option>
                        </select>
                        <span class="pagination-info" id="paginationInfo">Loading summary...</span>
                        <span id="tableLastSync" class="text-[10px] text-slate-400 font-mono ml-3"></span>
                    </div>
                    <div class="table-footer-right">
                        <button class="btn-pagination" id="btnPagePrev" disabled>
                            <i class="fa-solid fa-chevron-left"></i> Back
                        </button>
                        <button class="btn-pagination" id="btnPageNext" disabled>
                            Next <i class="fa-solid fa-chevron-right"></i>
                        </button>
                    </div>
                </div>
            </div>
        </div>
    </div>

    <!-- Toast Notification -->
    <div id="toast" class="toast">
        <div class="toast-icon">
            <i class="fa-solid fa-circle-check"></i>
        </div>
        <div class="toast-content">
            <div class="toast-title">Berhasil!</div>
            <div class="toast-message">Data berhasil dimuat</div>
        </div>
        <button class="toast-close" onclick="closeToast()">
            <i class="fa-solid fa-xmark"></i>
        </button>
    </div>

    @push('scripts')
        <link rel="stylesheet" href="https://cdn.jsdelivr.net/npm/flatpickr/dist/flatpickr.min.css">
        <script src="https://code.jquery.com/jquery-3.7.1.min.js" crossorigin="anonymous"></script>
        <script src="https://cdn.jsdelivr.net/npm/flatpickr"></script>

        <script>
            // Endpoint tabel & grid
            const TABLE_ENDPOINT = "{{ route('machines.table-data') }}";
            const GRID_ENDPOINT  = "{{ route('machines.get-data') }}";
            let tableStartPicker = null;
            let tableEndPicker   = null;
            let currentSortColumn = 'auto'; // Default auto-sort logic
            const tableState = {
                rows: [],
                page: 1,
                perPage: 20
            };

            const gridSensorMeta = [
                { key: 'amp',   label: 'AMP',   unit: 'A',  decimals: 2 },
                { key: 'hm',    label: 'HM',    unit: '',   decimals: 2 },
                { key: 'temp',  label: 'TEMP',  unit: '° C', decimals: 1 },
                { key: 'moist', label: 'MOIST', unit: '%',  decimals: 1 },
            ];

            const tableSensorMeta = gridSensorMeta.map(s => ({
                key: s.key,
                decimals: s.decimals,
                suffix: s.unit ? ' ' + s.unit : ''
            }));

            const modal = document.getElementById('customRangeModal');
            // Note: btnCustomRange is now only used for the Chart filter if it exists, or hidden.
            // The table has its own buttons now.

            // --- FLATPICKR SETUP ---
            const startPicker = flatpickr("#startDateTime", {
                enableTime: true,
                dateFormat: "Y-m-d H:i",
                time_24hr: true,
                maxDate: new Date(),
                minuteIncrement: 1,
                onChange: (_, dateStr) => endPicker.set('minDate', dateStr)
            });

            const endPicker = flatpickr("#endDateTime", {
                enableTime: true,
                dateFormat: "Y-m-d H:i",
                time_24hr: true,
                maxDate: new Date(),
                minuteIncrement: 1,
                onChange: (_, dateStr) => startPicker.set('maxDate', dateStr)
            });

            function refreshCustomRangeMax() {
                const now = new Date();
                startPicker.set('maxDate', now);
                endPicker.set('maxDate', now);
            }

            // --- MODAL FUNCTIONS ---
            window.openModal = function(){
                refreshCustomRangeMax();
                modal.classList.add('active');
                document.body.style.overflow = 'hidden';
            }
            window.closeModal = function(){
                modal.classList.remove('active');
                document.body.style.overflow = 'auto';
                startPicker.clear(); endPicker.clear();
                startPicker.set('maxDate', null);
                endPicker.set('minDate', null);
            }

            function showToast(type, title, message) {
                const toast = document.getElementById('toast');
                const icon = toast.querySelector('.toast-icon i');
                const titleEl = toast.querySelector('.toast-title');
                const messageEl = toast.querySelector('.toast-message');

                toast.classList.remove('success', 'error');
                toast.classList.add(type);
                titleEl.textContent = title;
                messageEl.textContent = message;

                if (type === 'success') {
                    icon.className = 'fa-solid fa-circle-check';
                } else if (type === 'error') {
                    icon.className = 'fa-solid fa-circle-exclamation';
                }

                toast.classList.add('active');
                setTimeout(closeToast, 5000);
            }

            function closeToast() {
                document.getElementById('toast').classList.remove('active');
            }

            // Bind modal buttons
            document.getElementById('btnCloseModal').onclick = closeModal;
            document.getElementById('btnCancel').onclick = closeModal;
            modal.onclick = (e) => { if(e.target === modal) closeModal(); };

            // Apply Range Action
            document.getElementById('btnApply').onclick = () => {
                const start = document.getElementById('startDateTime').value;
                const end = document.getElementById('endDateTime').value;

                if(!start || !end) {
                    showToast('error', 'Input Tidak Lengkap', 'Silakan pilih tanggal & waktu start dan end');
                    return;
                }
                const now = new Date();
                if (new Date(start) > now) return alert('Start tidak boleh melebihi waktu saat ini');
                if (new Date(end) > now) return alert('End tidak boleh melebihi waktu saat ini');
                if(new Date(start) >= new Date(end)) return alert('Start harus < End');

                closeModal();
                
                // Trigger Data Fetch for Table
                // Update UI button text if needed
                const btnCustom = document.getElementById('btnModeCustom');
                btnCustom.innerHTML = `<i class="fa-regular fa-calendar-check text-xs mr-1"></i> ${start} - ${end}`;
                
                // Set active mode
                setActiveMode('custom');
                
                // Fetch
                currentSortColumn = 'auto';
                tableState.page = 1;
                fetchTableData({ start, end, sort_by: 'auto' }, { showLoading: true });
            };

            // --- TABLE MODE SWITCHING ---
            window.switchTableMode = function(mode) {
                if(mode === 'custom') {
                    openModal();
                } else if(mode === 'latest') {
                    setActiveMode('latest');
                    // Reset custom range text
                    document.getElementById('btnModeCustom').innerHTML = `<i class="fa-regular fa-calendar-days"></i> Custom Range`;
                    currentSortColumn = 'auto'; // Reset to auto-sort on Summary mode
                    tableState.page = 1;
                    const filter = jQuery('#summaryFilterSelect').val();
                    fetchTableData({ filter: filter, sort_by: 'auto' }, { showLoading: true }); 
                }
            };
            
            // Listen to select change
            jQuery('#summaryFilterSelect').on('change', function() {
                switchTableMode('latest');
            });
            
            function setActiveMode(mode){
                jQuery('.btn-table-mode').removeClass('active');
                // Since btnModeLatest is gone and replaced by select, we just manage btnModeCustom
                if(mode === 'latest') {
                    // Highlight nothing or maybe the select container if we had one
                }
                if(mode === 'custom') {
                    jQuery('#btnModeCustom').addClass('active');
                }
            }

            // --- DATA FETCHING ---
            let tableRequestInFlight = false;
            function fetchTableData(params, options = {}){
                if (tableRequestInFlight) return;
                const showLoading = !!options.showLoading;
                // Always include current sort
                if(!params.sort_by) params.sort_by = currentSortColumn;
                
                updateSortIcons(params.sort_by);

                tableRequestInFlight = true;
                if (showLoading) {
                    setTableLoading(true);
                }
                jQuery.ajax({
                    url: TABLE_ENDPOINT,
                    method: 'GET',
                    data: params,
                    dataType: 'json',
                    success: function(res){
                        const rows = res.data || [];
                        renderTableRows(rows);
                    },
                    error: function(xhr){
                        console.error('Table fetch error:', xhr.responseText || xhr.statusText);
                        alert('Gagal memuat data tabel');
                    },
                    complete: function(){
                        tableRequestInFlight = false;
                        if (showLoading) {
                            setTableLoading(false);
                        }
                    }
                });
            }
            
            window.toggleSort = function(column) {
                currentSortColumn = column;
                tableState.page = 1;
                
                // If custom range active, fetch with custom range params
                if (jQuery('#btnModeCustom').hasClass('active')) {
                    const start = document.getElementById('startDateTime').value;
                    const end = document.getElementById('endDateTime').value;
                    if(start && end) {
                        fetchTableData({ start, end, sort_by: column }, { showLoading: false });
                        return;
                    }
                }
                
                // Else fetch with current summary filter
                const filter = jQuery('#summaryFilterSelect').val();
                fetchTableData({ filter, sort_by: column }, { showLoading: false });
            };
            
            function updateSortIcons(activeCol){
                // Reset all
                jQuery('thead th i').removeClass('text-indigo-600').addClass('text-slate-300');
                // Set active if exists
                const $target = jQuery(`#sort-icon-${activeCol}`);
                if($target.length) {
                    $target.removeClass('text-slate-300').addClass('text-indigo-600');
                }
            }

            function renderTableRows(rows){
                tableState.rows = Array.isArray(rows) ? rows : [];
                const total = tableState.rows.length;
                const perPage = tableState.perPage;
                const totalPages = total > 0 ? Math.ceil(total / perPage) : 1;
                if (tableState.page > totalPages) tableState.page = totalPages;
                if (tableState.page < 1) tableState.page = 1;

                const startIdx = (tableState.page - 1) * perPage;
                const pageRows = tableState.rows.slice(startIdx, startIdx + perPage);

                let html = '';

                pageRows.forEach(m => {
                    html += `
                        <tr class="border-b border-slate-100 hover:bg-slate-50 transition">
                            <td class="px-4 py-3 font-semibold text-slate-700">${esc(m.name ?? '-')}</td>
                            <td class="px-4 py-3 text-slate-600">${esc(m.last_updated ?? '-')}</td>

                            ${tableSensorMeta.map(s => {
                                const v = Number(m[s.key]);
                                const isFinite = Number.isFinite(v);
                                const txt = isFinite ? v.toFixed(s.decimals) : '-';
                                
                                // Highlighting logic
                                let cellClass = "font-semibold text-slate-900";

                                return `<td class="px-4 py-3 ${cellClass}">${esc(txt)}${s.suffix ? `<span class="text-xs text-slate-500 font-semibold"> ${esc(s.suffix)}</span>` : ''}</td>`;
                            }).join('')}
                        </tr>
                    `;
                });

                if (!html) {
                    const colCount = 2 + tableSensorMeta.length; 
                    html = `
                        <tr>
                            <td colspan="${colCount}" class="px-4 py-8 text-center text-slate-500">
                                Tidak ada data di range ini
                            </td>
                        </tr>
                    `;
                }

                jQuery('#machinesTableBody').html(html);
                
                // Update pagination info (Summary info)
                const endIdx = total > 0 ? Math.min(startIdx + pageRows.length, total) : 0;
                const info = total > 0
                    ? `Menampilkan ${startIdx + 1}-${endIdx} dari ${total} mesin - Halaman ${tableState.page}/${totalPages}`
                    : 'Tidak ada data';
                jQuery('#paginationInfo').text(info);

                // Update Last Sync Time
                const now = new Date();
                const timeStr = now.getHours().toString().padStart(2, '0') + ':' + 
                                now.getMinutes().toString().padStart(2, '0') + ':' + 
                                now.getSeconds().toString().padStart(2, '0');
                jQuery('#tableLastSync').text(`Last Sync: ${timeStr}`);

                updatePaginationControls(totalPages);
            }

            function esc(str){
                return String(str).replace(/[&<>"']/g, s => ({
                    '&':'&amp;','<':'&lt;','>':'&gt;','"':'&quot;',"'":'&#39;'
                }[s]));
            }

            function updatePaginationControls(totalPages){
                const prevBtn = document.getElementById('btnPagePrev');
                const nextBtn = document.getElementById('btnPageNext');
                if (!prevBtn || !nextBtn) return;

                const hasData = tableState.rows.length > 0;
                prevBtn.disabled = !hasData || tableState.page <= 1;
                nextBtn.disabled = !hasData || tableState.page >= totalPages;
            }

            function setTableLoading(isLoading){
                const perPageSelect = document.getElementById('perPageSelect');
                const summarySelect = document.getElementById('summaryFilterSelect');
                const customBtn = document.getElementById('btnModeCustom');
                const prevBtn = document.getElementById('btnPagePrev');
                const nextBtn = document.getElementById('btnPageNext');

                if (perPageSelect) perPageSelect.disabled = isLoading;
                if (summarySelect) summarySelect.disabled = isLoading;
                if (customBtn) customBtn.disabled = isLoading;

                if (isLoading) {
                    const colCount = 2 + tableSensorMeta.length;
                    jQuery('#machinesTableBody').html(`
                        <tr>
                            <td colspan="${colCount}" class="px-4 py-8 text-center text-slate-500">
                                Memuat data...
                            </td>
                        </tr>
                    `);
                    jQuery('#paginationInfo').text('Memuat data...');
                    if (prevBtn) prevBtn.disabled = true;
                    if (nextBtn) nextBtn.disabled = true;
                    return;
                }

                const totalPages = tableState.rows.length > 0
                    ? Math.ceil(tableState.rows.length / tableState.perPage)
                    : 1;
                updatePaginationControls(totalPages);
            }

            // --- AUTO REFRESH LOGIC ---
            let gridRequestInFlight = false;
            function fetchGridData() {
                if (gridRequestInFlight) return;
                gridRequestInFlight = true;
                jQuery.ajax({
                    url: GRID_ENDPOINT,
                    method: 'GET',
                    data: { _t: Date.now() }, // Cache busting
                    dataType: 'json',
                    success: function(res) {
                        renderGridCards(res.data || []);
                    },
                    error: function(err) {
                        console.error("Grid fetch failed", err);
                    },
                    complete: function(){
                        gridRequestInFlight = false;
                    }
                });
            }

            function toCardId(name, id) {
                const raw = (name ?? '').toString();
                const slug = raw.replace(/[^A-Za-z0-9_-]+/g, '-').replace(/^-+|-+$/g, '');
                const safe = slug || (id !== undefined && id !== null ? String(id) : 'unknown');
                return `card-${safe}`;
            }

            function cssEscape(value) {
                if (window.CSS && typeof window.CSS.escape === 'function') {
                    return window.CSS.escape(value);
                }
                return String(value).replace(/[^a-zA-Z0-9_-]/g, '\\$&');
            }

            function renderGridCards(machines) {
                const $grid = jQuery('#machineGrid');
                const seen = new Set();

                machines.forEach(m => {
                    const cardId = toCardId(m.name, m.id);
                    const selector = `#${cssEscape(cardId)}`;
                    let $card = jQuery(selector);
                    seen.add(cardId);

                    if (!$card.length) {
                        // CREATE CARD ONCE
                        let sensorsHtml = gridSensorMeta.map(s => `
                            <div class="rounded-xl bg-slate-50 p-3">
                                <div class="text-[10px] font-extrabold text-slate-500 uppercase tracking-wider">
                                    ${s.label}
                                </div>
                                <div class="mt-1 text-base font-black text-slate-900">
                                    <span class="sensor-value" data-sensor="${s.key}">-</span>
                                    ${s.unit ? `<span class="text-xs font-bold text-slate-500">${s.unit}</span>` : ''}
                                </div>
                            </div>
                        `).join('');

                        $grid.append(`
                            <div id="${cardId}" class="rounded-2xl border bg-white shadow-sm hover:shadow-md transition p-4">
                                <div class="text-sm font-extrabold text-slate-900">${esc(m.name ?? 'MESIN')}</div>
                                <div class="mt-1 text-[11px] font-mono text-slate-500 last-updated">-</div>
                                <div class="mt-4 grid grid-cols-2 gap-3 sensor-values">
                                    ${sensorsHtml}
                                </div>
                            </div>
                        `);

                        $card = jQuery(selector);
                    }

                    // UPDATE VALUES ONLY
                    $card.find('.last-updated').text(m.last_updated ?? '-');

                    gridSensorMeta.forEach(s => {
                        const v = Number(m[s.key]);
                        const isFinite = Number.isFinite(v);
                        const txt = isFinite ? v.toFixed(s.decimals) : '-';
                        
                        const $val = $card.find(`.sensor-value[data-sensor="${s.key}"]`);
                        $val.text(txt);
                        
                        // Highlighting grid box
                        const $box = $val.closest('.rounded-xl');
                        let isCritical = false;
                        /* if (isFinite) {
                            if (s.key === 'amp' && v < 14) isCritical = true;
                            if (s.key === 'temp' && (v < 55 || v > 65)) isCritical = true;
                            if (s.key === 'moist' && (v < 15 || v > 25)) isCritical = true;
                        } */

                        if (isCritical) {
                            $box.removeClass('bg-slate-50').addClass('bg-red-50 border border-red-100');
                            $val.removeClass('text-slate-900').addClass('text-red-700');
                        } else {
                            $box.removeClass('bg-red-50 border border-red-100').addClass('bg-slate-50');
                            $val.removeClass('text-red-700').addClass('text-slate-900');
                        }
                    });
                });

                $grid.children('[id^="card-"]').each(function(){
                    if (!seen.has(this.id)) {
                        jQuery(this).remove();
                    }
                });
            }

            // Polling setiap 3 detik
            // Grid: realtime
            setInterval(fetchGridData, 5000);

            // Table: setiap 5 detik (Summary)
            setInterval(() => {
                if (!jQuery('#btnModeCustom').hasClass('active')) {
                    const filter = jQuery('#summaryFilterSelect').val();
                    fetchTableData({ filter: filter }, { showLoading: false });
                }
            }, 5000);

            // Initial Loads
            fetchGridData();
            const initialFilter = jQuery('#summaryFilterSelect').val();
            fetchTableData({ filter: initialFilter }, { showLoading: false });

            (function initTablePagination(){
                const perPageSelect = document.getElementById('perPageSelect');
                const prevBtn = document.getElementById('btnPagePrev');
                const nextBtn = document.getElementById('btnPageNext');

                if (perPageSelect) {
                    tableState.perPage = parseInt(perPageSelect.value, 10) || 20;
                    perPageSelect.addEventListener('change', () => {
                        tableState.perPage = parseInt(perPageSelect.value, 10) || 20;
                        tableState.page = 1;
                        renderTableRows(tableState.rows);
                    });
                }

                if (prevBtn) {
                    prevBtn.addEventListener('click', () => {
                        if (tableState.page > 1) {
                            tableState.page -= 1;
                            renderTableRows(tableState.rows);
                        }
                    });
                }

                if (nextBtn) {
                    nextBtn.addEventListener('click', () => {
                        const totalPages = tableState.rows.length > 0
                            ? Math.ceil(tableState.rows.length / tableState.perPage)
                            : 1;
                        if (tableState.page < totalPages) {
                            tableState.page += 1;
                            renderTableRows(tableState.rows);
                        }
                    });
                }
            })();

            // ========== REPORT MODAL FUNCTIONS ==========
            let reportStartPicker = null;
            let reportEndPicker = null;

            // Initialize report datetime pickers
            reportStartPicker = flatpickr("#startDateTimeReport", {
                enableTime: true,
                dateFormat: "Y-m-d H:i",
                time_24hr: true,
                defaultHour: 7,
                defaultMinute: 0,
                maxDate: new Date(),
                minuteIncrement: 1,
                onChange: function(selectedDates, dateStr) {
                    if (reportEndPicker) {
                        reportEndPicker.set('minDate', dateStr);
                    }
                }
            });

            reportEndPicker = flatpickr("#endDateTimeReport", {
                enableTime: true,
                dateFormat: "Y-m-d H:i",
                time_24hr: true,
                defaultHour: 7,
                defaultMinute: 0,
                maxDate: new Date(),
                minuteIncrement: 1,
                onChange: function(selectedDates, dateStr) {
                    if (reportStartPicker) {
                        reportStartPicker.set('maxDate', dateStr);
                    }
                }
            });

            // Open Report Modal
            window.openReportModal = function() {
                const modal = document.getElementById('reportDownloadModal');
                const now = new Date();
                reportStartPicker.set('maxDate', now);
                reportEndPicker.set('maxDate', now);
                modal.classList.add('active');
                document.body.style.overflow = 'hidden';
            };

            // Close Report Modal
            window.closeReportModal = function() {
                const modal = document.getElementById('reportDownloadModal');
                modal.classList.remove('active');
                document.body.style.overflow = 'auto';
                
                // Reset form
                document.getElementById('reportForm').reset();
                reportStartPicker.clear();
                reportEndPicker.clear();
                reportStartPicker.set('maxDate', null);
                reportEndPicker.set('minDate', null);
                document.getElementById('hariKerjaInput').value = '';
            };



            // Bind modal close buttons
            document.getElementById('btnCloseReportModal').onclick = closeReportModal;
            document.getElementById('btnCancelReport').onclick = closeReportModal;
            document.getElementById('reportDownloadModal').onclick = function(e) {
                if (e.target === this) closeReportModal();
            };

            // Form Validation
            document.getElementById('reportForm').onsubmit = function(e) {
                const fields = [
                    { id: 'startDateTimeReport', name: 'Start Date' },
                    { id: 'endDateTimeReport', name: 'End Date' },
                    { id: 'lineInput', name: 'Line' },
                    { id: 'hariKerjaInput', name: 'Hari Kerja' },
                    { id: 'jamKerjaInput', name: 'Jam Kerja' },
                    { id: 'totalBriketInput', name: 'Total Briket' }
                ];

                for (let field of fields) {
                    const value = document.getElementById(field.id).value;
                    if (!value || value.trim() === '') {
                        Swal.fire({
                            icon: 'warning',
                            title: 'Oops...',
                            text: 'Mohon isi field ' + field.name + ' terlebih dahulu!',
                            confirmButtonColor: '#10b981',
                        });
                        e.preventDefault();
                        return false;
                    }
                }
                return true;
            };

        </script>
    @endpush
</x-app-layout>








