<?php if (isset($component)) { $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54 = $component; } ?>
<?php if (isset($attributes)) { $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54 = $attributes; } ?>
<?php $component = App\View\Components\AppLayout::resolve([] + (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag ? $attributes->all() : [])); ?>
<?php $component->withName('app-layout'); ?>
<?php if ($component->shouldRender()): ?>
<?php $__env->startComponent($component->resolveView(), $component->data()); ?>
<?php if (isset($attributes) && $attributes instanceof Illuminate\View\ComponentAttributeBag): ?>
<?php $attributes = $attributes->except(\App\View\Components\AppLayout::ignoredParameterNames()); ?>
<?php endif; ?>
<?php $component->withAttributes([]); ?>
    <header class="dashboard-header">
        <span class="text-xs uppercase tracking-wide text-white/80 flex items-center gap-2">
            <i class="fa-solid fa-microchip"></i>
            Sensor Details
        </span>
        <h1><?php echo e($sensor->name); ?></h1>
    </header>

    <div class="content-container">
        <?php if(session('success')): ?>
            <div class="alert alert-success mb-4">
                <i class="fa-solid fa-check-circle"></i>
                <?php echo e(session('success')); ?>

            </div>
        <?php endif; ?>

        <!-- Sensor Overview -->
        <div class="grid grid-cols-4 gap-4 mb-6">
            <div class="info-card">
                <div class="info-label">Sensor Code</div>
                <div class="info-value font-mono"><?php echo e($sensor->sensor_code); ?></div>
            </div>
            <div class="info-card">
                <div class="info-label">Type</div>
                <div class="info-value"><?php echo e($sensor->sensorType->name); ?> (<?php echo e($sensor->sensorType->unit); ?>)</div>
            </div>
            <div class="info-card">
                <div class="info-label">Location</div>
                <div class="info-value text-sm"><?php echo e($sensor->location); ?></div>
            </div>
            <div class="info-card">
                <div class="info-label">Status</div>
                <div class="info-value">
                    <span class="status-indicator <?php echo e($sensor->status === 'active' ? 'online' : ($sensor->status === 'inactive' ? 'offline' : 'maintenance')); ?>">
                        <span class="pulse"></span>
                        <?php echo e(ucfirst($sensor->status)); ?>

                    </span>
                </div>
            </div>
        </div>

        <div class="grid grid-cols-3 gap-4 mb-6">
            <!-- Sensor Information Panel -->
            <div class="col-span-2">
                <div class="card">
                    <div class="card-header flex items-center justify-between">
                        <h3>Sensor Information</h3>
                        <a href="<?php echo e(route('sensors.edit', $sensor)); ?>" class="btn btn-secondary btn-sm">
                            <i class="fa-solid fa-pen-to-square"></i>
                            Edit
                        </a>
                    </div>
                    <div class="card-body space-y-4">
                        <div class="info-row">
                            <span class="info-label">Sensor Type</span>
                            <span class="info-value">
                                <?php echo e($sensor->sensorType->name); ?> (<?php echo e($sensor->sensorType->unit); ?>)
                            </span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Location</span>
                            <span class="info-value">
                                <i class="fa-solid fa-map-pin mr-2"></i>
                                <?php echo e($sensor->location); ?>

                            </span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Description</span>
                            <span class="info-value"><?php echo e($sensor->description ?? 'No description'); ?></span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Created</span>
                            <span class="info-value"><?php echo e($sensor->created_at->format('M d, Y H:i')); ?></span>
                        </div>
                        <div class="info-row">
                            <span class="info-label">Last Updated</span>
                            <span class="info-value"><?php echo e($sensor->updated_at->format('M d, Y H:i')); ?></span>
                        </div>
                    </div>
                </div>
            </div>

            <!-- Quick Stats -->
            <div class="card">
                <div class="card-header">
                    <h3>Statistics</h3>
                </div>
                <div class="card-body space-y-4">
                    <div class="stat-item">
                        <div class="stat-number"><?php echo e($sensor->readings->count()); ?></div>
                        <div class="stat-label">Total Readings</div>
                    </div>
                    <?php if($sensor->readings->isNotEmpty()): ?>
                        <div class="stat-item">
                            <div class="stat-number"><?php echo e($sensor->readings->max('value')); ?></div>
                            <div class="stat-label">Max Value</div>
                        </div>
                        <div class="stat-item">
                            <div class="stat-number"><?php echo e(number_format($sensor->readings->avg('value'), 2)); ?></div>
                            <div class="stat-label">Average Value</div>
                        </div>
                    <?php endif; ?>
                </div>
            </div>
        </div>

        <!-- Sensor Readings -->
        <div class="card">
            <div class="card-header">
                <h3>
                    <i class="fa-solid fa-chart-line mr-2"></i>
                    Recent Readings
                </h3>
            </div>
            <?php if($sensor->readings->isNotEmpty()): ?>
                <div class="table-responsive">
                    <table class="data-table">
                        <thead>
                            <tr>
                                <th>Value</th>
                                <th>Unit</th>
                                <th>Timestamp</th>
                            </tr>
                        </thead>
                        <tbody>
                            <?php $__currentLoopData = $sensor->readings->take(20); $__env->addLoop($__currentLoopData); foreach($__currentLoopData as $reading): $__env->incrementLoopIndices(); $loop = $__env->getLastLoop(); ?>
                                <tr>
                                    <td class="text-blue-600 font-semibold"><?php echo e(number_format($reading->value, 2)); ?></td>
                                    <td><?php echo e($sensor->sensorType->unit); ?></td>
                                    <td class="text-sm text-muted">
                                        <?php echo e($reading->recorded_at->format('M d, H:i:s')); ?>

                                    </td>
                                </tr>
                            <?php endforeach; $__env->popLoop(); $loop = $__env->getLastLoop(); ?>
                        </tbody>
                    </table>
                </div>
            <?php else: ?>
                <div class="empty-state py-8">
                    <i class="fa-solid fa-chart-line opacity-30"></i>
                    <p>No readings yet</p>
                </div>
            <?php endif; ?>
        </div>

        <!-- Form Actions -->
        <div class="form-actions mt-6">
            <a href="<?php echo e(route('sensors.index')); ?>" class="btn btn-secondary">
                <i class="fa-solid fa-arrow-left"></i>
                Back to Sensors
            </a>
            <form action="<?php echo e(route('sensors.destroy', $sensor)); ?>" method="POST" class="inline"
                onsubmit="return confirm('Delete this sensor and all its readings? This action cannot be undone.');">
                <?php echo csrf_field(); ?>
                <?php echo method_field('DELETE'); ?>
                <button type="submit" class="btn btn-danger">
                    <i class="fa-solid fa-trash"></i>
                    Delete Sensor
                </button>
            </form>
        </div>
    </div>
 <?php echo $__env->renderComponent(); ?>
<?php endif; ?>
<?php if (isset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $attributes = $__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__attributesOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php if (isset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54)): ?>
<?php $component = $__componentOriginal9ac128a9029c0e4701924bd2d73d7f54; ?>
<?php unset($__componentOriginal9ac128a9029c0e4701924bd2d73d7f54); ?>
<?php endif; ?>
<?php /**PATH D:\proyek-oping\web-monitoring-laravel\iot-thks\resources\views\sensors\show.blade.php ENDPATH**/ ?>