@extends('layouts.main', ['title' => 'Tuju Kuda - Laporan TRIA'])
@section('styles')
    <!-- Add PDF and Excel libraries -->
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf/2.5.1/jspdf.umd.min.js"></script>
    <script src="https://cdnjs.cloudflare.com/ajax/libs/jspdf-autotable/3.8.1/jspdf.plugin.autotable.min.js"></script>
    <script src="https://cdn.sheetjs.com/xlsx-0.20.1/package/dist/xlsx.full.min.js"></script>
@endsection
@section('content')
    <!--begin::App Main-->
    <main class="app-main">
        <!--begin::App Content Header-->
        <div class="app-content-header">
            <!--begin::Container-->
            <div class="container-fluid">
                <!--begin::Row-->
                <div class="row">
                    <div class="col-sm-6">
                        <h3 class="mb-0">Laporan TRIA</h3>
                    </div>
                    <div class="col-sm-6">
                        <ol class="breadcrumb float-sm-end">
                            <li class="breadcrumb-item"><a href="{{ route('home') }}">Home</a></li>
                            <li class="breadcrumb-item active" aria-current="page">Laporan TRIA</li>
                        </ol>
                    </div>
                </div>
                <!--end::Row-->
            </div>
            <!--end::Container-->
        </div>
        <!--end::App Content Header-->
        <!--begin::App Content-->
        <div class="app-content">
            <!--begin::Container-->
            <div class="container-fluid">
                <!--begin::Row-->
                <div class="row">
                    <div class="card">
                        <div class="card-header">
                            <div class="d-flex justify-content-between align-items-center">
                                <h3 class="card-title">Laporan TRIA</h3>
                                <div>
                                    <button class="btn btn-success btn-sm" onclick="exportToExcel()">
                                        <i class="bi bi-file-earmark-excel"></i> Export Excel
                                    </button>
                                    <button class="btn btn-danger btn-sm" onclick="exportToPDF()">
                                        <i class="bi bi-file-earmark-pdf"></i> Export PDF
                                    </button>
                                </div>
                            </div>
                        </div>
                        <!-- /.card-header -->
                        <div class="card-body">
                            <table id="laporanTable" class="table table-bordered table-sm text-center align-middle">
                                <div class="card-header" align="center">
                                    TOTAL STOK BOX EXPORT TRIA<br>
                                    PER TANGGAL 14 AGUSTUS 2025
                                </div>
                                <thead class="table-secondary">
                                    <tr>
                                        <th rowspan="2">PABRIK</th>
                                        <th rowspan="2">GRADE</th>
                                        <th colspan="14">DSP</th>
                                        <th colspan="2">TOTAL</th>
                                        <th colspan="2">GRAND TOTAL</th>
                                    </tr>
                                    <tr>
                                        <th colspan="2">DAESHIN</th>
                                        <th colspan="2">NEWSUN</th>
                                        <th colspan="2">HTRIAM</th>
                                        <th colspan="2">SE</th>
                                        <th colspan="2">HJ</th>
                                        <th colspan="2">DJ</th>
                                        <th colspan="2">EVERGREEN</th>
                                        <th>BOX</th>
                                        <th>CONT</th>
                                        <th>BOX</th>
                                        <th>CONT</th>
                                    </tr>
                                </thead>
                                <tbody>
                                    <tr>
                                        <td rowspan="2">MENGANTI</td>
                                        <td>A</td>
                                        <td>652</td>
                                        <td>0.21</td>
                                        <td>285</td>
                                        <td>0.09</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>99</td>
                                        <td>0.03</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>21</td>
                                        <td>0.01</td>
                                        <td>1,057</td>
                                        <td>0.34</td>
                                        <td>5,184</td>
                                        <td>1.67</td>
                                    </tr>
                                    <tr>
                                        <td>B</td>
                                        <td>3,276</td>
                                        <td>0.93</td>
                                        <td>650</td>
                                        <td>0.21</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>102</td>
                                        <td>0.10</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>279</td>
                                        <td>0.09</td>
                                        <td>4,127</td>
                                        <td>1.33</td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <!-- Contoh Banjar -->
                                    <tr>
                                        <td rowspan="3">BANJAR</td>
                                        <td>BB</td>
                                        <td>2294</td>
                                        <td>0.70</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>1,044</td>
                                        <td>0.32</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>3,338</td>
                                        <td>1.01</td>
                                        <td>5,072</td>
                                        <td>1.54</td>
                                    </tr>
                                    <tr>
                                        <td>CC Pig</td>
                                        <td>1325</td>
                                        <td>0.40</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>409</td>
                                        <td>0.12</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>1,734</td>
                                        <td>0.53</td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <tr>
                                        <td>CC Predk</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td>0</td>
                                        <td></td>
                                        <td></td>
                                    </tr>
                                    <!-- Tambahkan baris sesuai tabel lain (Semarang, Pasuruan, Sorong, dst) -->
                                </tbody>
                                <tfoot class="table-secondary fw-bold">
                                    <tr>
                                        <td colspan="2">TOTAL</td>
                                        <td>11,686</td>
                                        <td>3.61</td>
                                        <td>1,591</td>
                                        <td>0.51</td>
                                        <td>12</td>
                                        <td>0.00</td>
                                        <td>0</td>
                                        <td>0.00</td>
                                        <td>434</td>
                                        <td>0.14</td>
                                        <td>5,098</td>
                                        <td>1.57</td>
                                        <td>300</td>
                                        <td>0.10</td>
                                        <td>19,121</td>
                                        <td>5.93</td>
                                        <td>19,121</td>
                                        <td>5.93</td>
                                    </tr>
                                </tfoot>
                            </table>
                        </div>

                        <!-- /.card-body -->
                        <div class="card-footer clearfix">
                            <ul class="pagination pagination-sm m-0 float-end">
                                <li class="page-item"><a class="page-link" href="#">&laquo;</a></li>
                                <li class="page-item"><a class="page-link" href="#">1</a></li>
                                <li class="page-item"><a class="page-link" href="#">2</a></li>
                                <li class="page-item"><a class="page-link" href="#">3</a></li>
                                <li class="page-item"><a class="page-link" href="#">&raquo;</a></li>
                            </ul>
                        </div>
                        <!-- /.card -->
                    </div>
                </div>
                <!--end::Row-->
            </div>
            <!--end::Container-->
        </div>
        <!--end::App Content-->
    </main>
    <!--end::App Main-->
@endsection
@section('jsscript')
    <!--begin::Script-->
    <!--begin::Third Party Plugin(OverlayScrollbars)-->
    <script src="https://cdn.jsdelivr.net/npm/overlayscrollbars@2.11.0/browser/overlayscrollbars.browser.es6.min.js"
        crossorigin="anonymous"></script>
    <!--end::Third Party Plugin(OverlayScrollbars)--><!--begin::Required Plugin(popperjs for Bootstrap 5)-->
    <script src="https://cdn.jsdelivr.net/npm/@popperjs/core@2.11.8/dist/umd/popper.min.js" crossorigin="anonymous">
    </script>
    <!--end::Required Plugin(popperjs for Bootstrap 5)--><!--begin::Required Plugin(Bootstrap 5)-->
    <script src="https://cdn.jsdelivr.net/npm/bootstrap@5.3.7/dist/js/bootstrap.min.js" crossorigin="anonymous"></script>
    <!--end::Required Plugin(Bootstrap 5)--><!--begin::Required Plugin(AdminLTE)-->
    <script src="../js/adminlte.js"></script>
    <!--end::Required Plugin(AdminLTE)--><!--begin::OverlayScrollbars Configure-->
    <script>
        const SELECTOR_SIDEBAR_WRAPPER = '.sidebar-wrapper';
        const Default = {
            scrollbarTheme: 'os-theme-light',
            scrollbarAutoHide: 'leave',
            scrollbarClickScroll: true,
        };
        document.addEventListener('DOMContentLoaded', function() {
            const sidebarWrapper = document.querySelector(SELECTOR_SIDEBAR_WRAPPER);
            if (sidebarWrapper && OverlayScrollbarsGlobal?.OverlayScrollbars !== undefined) {
                OverlayScrollbarsGlobal.OverlayScrollbars(sidebarWrapper, {
                    scrollbars: {
                        theme: Default.scrollbarTheme,
                        autoHide: Default.scrollbarAutoHide,
                        clickScroll: Default.scrollbarClickScroll,
                    },
                });
            }
        });
    </script>
    <!--end::OverlayScrollbars Configure-->
    <script>
        function exportToExcel() {
            const table = document.querySelector('table');
            const wb = XLSX.utils.table_to_book(table, {
                sheet: "TOTAL STOK BOX EXPORT TRIA"
            });
            XLSX.writeFile(wb, 'Laporan_TRIA.xlsx');
        }

        function exportToPDF() {
            const {
                jsPDF
            } = window.jspdf;
            const doc = new jsPDF('l', 'pt', 'a4');

            // Add title
            doc.setFontSize(18);
            doc.text('TOTAL STOK BOX EXPORT TRIA ', 40, 40);

            // Add the table
            doc.autoTable({
                html: 'table',
                startY: 50,
                theme: 'grid',
                headStyles: {
                    fillColor: [169, 169, 169]
                },
                columnStyles: {
                    0: {
                        cellWidth: 60
                    },
                    1: {
                        cellWidth: 40
                    }
                },
                didDrawPage: function(data) {
                    // Add footer
                    doc.setFontSize(10);
                    doc.text('Page ' + doc.internal.getNumberOfPages(), data.settings.margin.left, doc.internal
                        .pageSize.height - 10);
                }
            });

            // Save the PDF
            doc.save('Laporan_TRIA.pdf');
        }
    </script>
    <!--end::Script-->
@endsection
